<!--  
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.package tutorial;
-->
<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
	pageEncoding="ISO-8859-1"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
<title>Inventory Status</title>
<%@ page import="java.util.*, tutorial.*"%>
<%        
	InventoryEntityBroker broker = new InventoryEntityBroker();

	List<InventoryItem> itemList= broker.getAllItems();
	List<InventoryCategory> categoryList= broker.getAllCategories();
	List<InventoryItem> selectedCategoryList = null;
	int selectedId = 0;

    String url = request.getRequestURI();
	String buttonName=request.getParameter("itemButton");
	if(buttonName != null && !buttonName.isEmpty())
	{
		if(buttonName.equalsIgnoreCase("Add"))
		{
			String name = request.getParameter("itemName");
			String description = request.getParameter("itemDescription");
			float price = Float.parseFloat(request.getParameter("itemPrice"));
			int itemCatID = Integer.parseInt(request.getParameter("itemCatList"));
			broker.addItem(name, description, price, itemCatID);
		}
		else if(buttonName.equalsIgnoreCase("Update"))
		{
			int id = Integer.parseInt(request.getParameter("ItemList"));
			String name = request.getParameter("itemName");
			String description = request.getParameter("itemDescription");
			float price = Float.parseFloat(request.getParameter("itemPrice"));
			int itemCatID = Integer.parseInt(request.getParameter("itemCatList"));
			broker.updateItem(id, name, description, price, itemCatID);
		}
		else if(buttonName.equalsIgnoreCase("Delete"))
		{
			int id = Integer.parseInt(request.getParameter("ItemList"));
			broker.deleteItem(id);
		}
	}
	
	String buttonNameCat=request.getParameter("catButton");
	if(buttonNameCat != null && !buttonNameCat.isEmpty())
	{
		if(buttonNameCat.equalsIgnoreCase("Add"))
		{
			String name = request.getParameter("catName");
			String description = request.getParameter("catDescription");
			broker.addCategory(name, description);
		}
		else if(buttonNameCat.equalsIgnoreCase("Update"))
		{
			int id = Integer.parseInt(request.getParameter("CatList"));
			String name = request.getParameter("catName");
			String description = request.getParameter("catDescription");
			broker.updateCategory(id, name, description);
		}
		else if(buttonNameCat.equalsIgnoreCase("Delete"))
		{
			int id = Integer.parseInt(request.getParameter("CatList"));
			broker.deleteCategory(id);
		}
	
		if(buttonNameCat.equalsIgnoreCase("Filter"))
		{
			int id = Integer.parseInt(request.getParameter("CatList"));
			if(id != 0)
			{
				selectedCategoryList = broker.getSingleCategory(id).getItems();
			}
			else
			{
				selectedCategoryList = itemList;
			}
			selectedId = id;
		}
	}
	
	itemList= broker.getAllItems();
	categoryList= broker.getAllCategories();
 %>
<script type="text/javascript">
   var currentCat = "";
	function showItems(cat)
	{
		var options=
	        <%
	        out.print("\"<select size=15 style=\\\"width: 200px\\\" name=ItemList>");
			
			List<InventoryItem> list = itemList;
			if(selectedCategoryList != null)
			{
				list = selectedCategoryList;
			}
	        for(int i=0; i < list.size(); i++)
	        {
	        	out.print("<option onclick=\\\"fillItemFields(" + i + ")\\\" value=\\\"" + 
	        			list.get(i).getId() + "\\\">" + list.get(i).getItemName() + "</option>");
	        }
	        out.print("</select>\";");
	        %>
		if(cat == "")
		{
			cat=options;
		}
		
		document.write(cat);
   	}
	function fillItemFields(id)
	{
        var itemArray = new Array();
        <%
		list = itemList;
		if(selectedCategoryList != null)
		{
			list = selectedCategoryList;
		}
        for(int i=0; i < list.size(); i++)
        {
            out.println("itemArray[" + i + "] = [" + list.get(i).getId() + 
            		", \"" + list.get(i).getItemName() + "\", \"" + 
            		list.get(i).getItemDescription() + "\", \"" +
            		list.get(i).getItemPrice() + "\", \"" +
            		list.get(i).getCategory().getId() +
            		"\"];");
		}
        %>
        
        document.getElementById("itemName").value = itemArray[id][1];
        document.getElementById("itemDescription").value = itemArray[id][2];
        document.getElementById("itemPrice").value = itemArray[id][3];
        var catID = "cat"+itemArray[id][4];
        document.getElementById(catID).selected=true;
	}
	function fillCatFields(id)
	{
        var catArray = new Array();
        <%
        for(int i=0; i < categoryList.size(); i++)
        {
            out.println("catArray[" + i + "] = [" + categoryList.get(i).getId() + 
            		", \"" + categoryList.get(i).getCategoryName() + "\", \"" + 
            		categoryList.get(i).getCategoryDescription() + 
            		"\"];");
		}
        %>
        
        document.getElementById("catName").value = catArray[id][1];
        document.getElementById("catDescription").value = catArray[id][2];
	}
</script>

</head>
<body bgcolor="#308BCF">
<form action="<%= url %>" method=post>
<center>
<table border=1 cellpadding=3>
	<tr>
		<th colspan=2 style="color: White; background-color: Blue;">Inventory
		Item Control</th>
	</tr>
	<tr>
		<td rowspan="2"><script type="text/javascript">
        	showItems("");
        </script></td>
		<td>Item Name<br>
		<input name=itemName type=text ID=itemName><br>
		Item Description<br>
		<input name=itemDescription type=text ID=itemDescription><br>
		Item Price<br>
		$<input name=itemPrice type=text ID=itemPrice><br>
		Item Category<br>
		<select style="width: 200px" name=itemCatList ID=itemCat>
			<%
		        for(int i=0; i < categoryList.size(); i++)
		        {
		        	out.println("<option onclick=\"fillCatFields(" + i + ")\" value=\"" + 
		        			categoryList.get(i).getId() + "\" id=\"cat" + categoryList.get(i).getId() + 
		        			"\">" + categoryList.get(i).getCategoryName() + "</option>");
		        }
		        %>
		</select></td>
	</tr>

	<tr>
		<td colspan=2><input type=submit name=itemButton value=Add>
		<input type=submit name=itemButton value=Update> <input
			type=submit name=itemButton value=Delete></td>
	</tr>
</table>
</center>
</form>

<form action="<%= url %>" method=post id=catForm>
<center>
<table border=1 cellpadding=3>
	<tr>
		<th colspan=2 style="color: White; background-color: Blue;">Inventory
		Category Control</th>
	</tr>
	<tr>
		<td rowspan="2"><select size=10 style="width: 200px" name=CatList>
			<option selected="selected" value="0" id="0">All</option>
			<%
        int index = -1;
        for(int i=0; i < categoryList.size(); i++)
        {
        	out.println("<option onclick=\"fillCatFields(" + i + ")\" value=\"" + 
        			categoryList.get(i).getId() + "\"" + 
        			(selectedId == categoryList.get(i).getId()?" selected=selected":"") +
        			">" + categoryList.get(i).getCategoryName() + "</option>");
        	if(selectedId == categoryList.get(i).getId())
        	{
        		index = i;
        	}
        }
        %>
		</select></td>
		<td>Category Name<br>
		<input name=catName type=text ID=catName><br>
		Category Description<br>
		<input name=catDescription type=text ID=catDescription><br>
		<br>
		<input type=submit name=catButton value=Filter></td>
	</tr>
	<tr>
		<td colspan=2><input type=submit name=catButton value=Add>
		<input type=submit name=catButton value=Update> <input
			type=submit name=catButton value=Delete></td>
	</tr>
</table>
</center>
</form>
<%
			if(index != -1)
			{
				out.println("<script type=\"text/javascript\">fillCatFields(" + index + ");</script>");
			}
		%>
</body>
</html>